DMG-CPU1.5.SF2
==============

ゲームボーイ音源をサンプリングしたMIDI音源（サウンドフォント）です。  
お使いいただくにはサウンドフォントに対応したハードやソフトが必要です。

## はじめに ##########################################################

「DMG-CPU1.5.SF2」はゲームボーイ音源をサンプリングして、枯れた技術で
あるサウンドフォントのSF2フォーマットに編集したものです。

「DMG-CPU1.5.SF2」をiOSアプリの「bs-16i」や、パソコンのDAWソフトなどに
読み込むと、iPhone・iPad・パソコンをゲームボーイの音がする楽器として
使うことができるようになります。

さて、近年国内外で昔のパソコンやゲーム機を演奏活動に取り入れた
チップチューンという音楽スタイルが注目を集めています。  
ゲームボーイはチップチューンの代表的な楽器であり、その洗練されたデザインは
ファッションアイテムとしても世代を超えて愛されています。

昔のパソコンやゲーム機を楽器として使うには、ソフトやハードについての
専門知識が必要になる場合が多いですが、DAWソフトの基本操作ができれば、
あとは打ち込みのちょっとしたコツを覚えるだけで簡単にチップチューンを
作ることができるようになるでしょう。

「DMG-CPU1.5.SF2」は、実際にゲームボーイの開発現場で使用していた
デフォルト設定を参考にした即戦力系の音色になっています。  
さらに打ち込みの手間が省ける便利な音色も多数収録しており、
懐かしくも新しい音楽を作るのにうってつけのライブラリになっています。

## 目次 ##############################################################

* §1 音色マップ・キーマップ
  * 音色マップ（MIDIチャンネル1～9, 11～16）
  * 音色マップ（MIDIチャンネル10）
  * Square Perc.キーマップ
  * Guitar & Drum Kitキーマップ
* §2 MIDIデータ作成ガイド
  * 発音数などの制約
  * トラック音量（ボリューム、エクスプレッション）
  * ノート音量（ベロシティ）
  * パン
* §3 沿革
  * Gameboy.SF2 (Ver.2003-11-20)
  * PocketCamera.SF2 (Ver.2004-04-29)
  * DMG-CPU.SF2 (Ver.2007-12-18)
  * GBMC_Drums.SF2 (Ver.2009-12-20)
  * DMG-CPU2.SF2 (Ver.2012-01-26)
  * DMG-CPU1.5.SF2 (Ver.2012-03-17)
* §4 ライセンスについて
* §5 DMG-CPU1.5.SF2以外の選択肢
  * ゲームボーイソフト
  * トラッカー
  * ハードウェア
  * シーケンサー
  * プラグイン
  * サウンドフォント
  * サンプルパック
  * MMLコンパイラ
  * オンラインコンバータ
  * 参考資料
* §6 基礎知識
  * ゲームボーイについて
  * サウンドフォントについて
  * サンプラーについて
  * DAWソフトについて
* §7 お問い合わせ先

----------------------------------------------------------------------

§1 音色マップ・キーマップ
--------------------------

### 音色マップ（MIDIチャンネル1～9, 11～16） #########################

* 矩形波21音色、波形メモリ37音色、ノイズ1音色を搭載しています。
* 矩形波の音域外にキック等のサブ音色があり、メロディーに割り込ませることができます。
* 全音色にExclusive Classを設定しているため、強制的に単音で発音されます。

P.C.
: プログラムチェンジ

CH
: ゲームボーイ音源のチャンネル
  * CH1 矩形波
  * CH2 矩形波
  * CH3 波形メモリ
  * CH4 ノイズ

|P.C.    |使用可能CH|メイン音色名            |サブ音色名        |
|--------|----------|------------------------|------------------|
|001     |CH1, CH2  |Square 1:1              |+ Square Perc. 1:1|
|002     |CH1, CH2  |SQ 1:1 Down7 Modulation1|+ Square Perc. 1:1|
|003     |CH1, CH2  |SQ 1:1 Down7 Modulation2|+ Square Perc. 1:1|
|004     |CH1, CH2  |Square 1:3              |+ Square Perc. 1:3|
|005     |CH1, CH2  |SQ 1:3 Down7 Modulation1|+ Square Perc. 1:3|
|006     |CH1, CH2  |SQ 1:3 Down7 Modulation2|+ Square Perc. 1:3|
|007     |CH1, CH2  |Square 1:7              |+ Square Perc. 1:7|
|008     |CH1, CH2  |SQ 1:7 Down7 Modulation1|+ Square Perc. 1:7|
|009     |CH1, CH2  |SQ 1:7 Down7 Modulation2|+ Square Perc. 1:7|
|010     |CH1, CH2  |SQ 1:1 Fast Arp 2Oct    |+ Square Perc. 1:1|
|011     |CH1, CH2  |SQ 1:3 Fast Arp 2Oct    |+ Square Perc. 1:3|
|012     |CH1, CH2  |SQ 1:7 Fast Arp 2Oct    |+ Square Perc. 1:7|
|013     |CH1, CH2  |SQ 1:1 Fast Arp 3Oct    |+ Square Perc. 1:1|
|014     |CH1, CH2  |SQ 1:3 Fast Arp 3Oct    |+ Square Perc. 1:3|
|015     |CH1, CH2  |SQ 1:7 Fast Arp 3Oct    |+ Square Perc. 1:7|
|016     |CH1, CH2  |SQ 1:1 Power Chord      |+ Square Perc. 1:1|
|017     |CH1, CH2  |SQ 1:3 Power Chord      |+ Square Perc. 1:3|
|018     |CH1, CH2  |SQ 1:7 Power Chord      |+ Square Perc. 1:7|
|019     |CH1, CH2  |SQ 1:1 Orchestra Hit    |+ Square Perc. 1:1|
|020     |CH1, CH2  |SQ 1:3 Orchestra Hit    |+ Square Perc. 1:3|
|021     |CH1, CH2  |SQ 1:7 Orchestra Hit    |+ Square Perc. 1:7|
|022     |CH3       |VRC6 Square 8/16        |―                |
|023     |CH3       |VRC6 Square 7/16        |―                |
|024     |CH3       |VRC6 Square 6/16        |―                |
|025     |CH3       |VRC6 Square 5/16        |―                |
|026     |CH3       |VRC6 Square 4/16        |―                |
|027     |CH3       |VRC6 Square 3/16        |―                |
|028     |CH3       |VRC6 Square 2/16        |―                |
|029     |CH3       |VRC6 Square 1/16        |―                |
|030     |CH3       |VRC6 Saw                |―                |
|031     |CH3       |FC Triangle             |―                |
|032     |CH3       |SCC Saw1                |―                |
|033     |CH3       |SCC Saw2                |―                |
|034     |CH3       |SCC Triangle1           |―                |
|035     |CH3       |SCC Triangle2           |―                |
|036     |CH3       |SCC Sine1               |―                |
|037     |CH3       |SCC Sine2               |―                |
|038     |CH3       |SCC Bass                |―                |
|039     |CH3       |SCC Guitar1             |―                |
|040     |CH3       |SCC Guitar2             |―                |
|041     |CH3       |SCC Guitar3             |―                |
|042     |CH3       |SCC Organ1              |―                |
|043     |CH3       |SCC Organ2              |―                |
|044     |CH3       |SCC Organ3              |―                |
|045     |CH3       |SCC Piano               |―                |
|046     |CH3       |SCC Harmonica           |―                |
|047     |CH3       |SCC Strings1            |―                |
|048     |CH3       |SCC Strings2            |―                |
|049     |CH3       |SCC Brass1              |―                |
|050     |CH3       |SCC Brass2              |―                |
|051     |CH3       |SCC Brass3              |―                |
|052     |CH3       |SCC Lead1               |―                |
|053     |CH3       |SCC Lead2               |―                |
|054     |CH3       |SCC Lead3               |―                |
|055     |CH3       |SCC Lead4               |―                |
|056     |CH3       |SCC Lead5               |―                |
|057     |CH3       |SCC Double Lead1        |―                |
|058     |CH3       |SCC Double Lead2        |―                |
|059～127|―        |―                      |―                |
|128     |CH4       |Guitar & Drum Kit (Sub) |―                |

※P.C.128はMIDIチャンネル10以外でCH4を鳴らしたい場合に使います。

### 音色マップ（MIDIチャンネル10） ###################################

|P.C.    |使用可能CH|音色名                  |
|--------|----------|------------------------|
|001     |CH4       |Guitar & Drum Kit       |

### Square Perc.キーマップ ###########################################

* ノートNo.024 (C) ～ 127 (G)はメイン音色が発音されます。
* ゲームボーイ音源はスイープが1つしかありませんので、重ねて鳴らすことは非推奨です。
* Studio OneなどでノートNo.000が鳴らない場合があります。あらかじめご了承ください。

|ノートNo. |音色名            |
|----------|------------------|
|000 (C-1) |Square Bass Drum1 |
|001 (C#-1)|Square Bass Drum2 |
|002 (D-1) |Square Bass Drum3 |
|003 (D#-1)|Square Bass Drum4 |
|004 (E-1) |Square Snare Drum1|
|005 (F-1) |Square Snare Drum2|
|006 (F#-1)|Square Tom1       |
|007 (G-1) |Square Tom2       |
|008 (G#-1)|Square Tom3       |
|009 (A-1) |Square Tom4       |
|010 (A#-1)|Square Tom5       |
|011 (B-1) |Square Tom6       |
|012 (C0)  |Square Tom7       |
|013 (C#0) |Square Tom8       |
|014 (D0)  |Square Tom9       |
|015 (D#0) |Square Tom10      |
|016 (E0)  |Square Tom11      |
|017 (F0)  |Square Tom12      |
|018 (F#0) |Square Tom13      |
|019 (G0)  |Square Tom14      |
|020 (G#0) |Square Tom15      |
|021 (A0)  |Square Tom16      |
|022 (A#0) |Square Tom17      |
|023 (B0)  |Square Tom18      |

### Guitar & Drum Kitキーマップ ######################################

↑↓
: サンプラーで音階を付けています。

☆
: 実機で鳴る音程です。

★
: 便宜上同じ音が鳴ります。

|ノートNo. |音色名               |
|----------|---------------------|
|000 (C-1) |↑                   |
|001 (C#-1)|↑                   |
|002 (D-1) |Noise Guitar D1 ☆   |
|003 (D#-1)|↓                   |
|004 (E-1) |↓                   |
|005 (F-1) |Noise Guitar F1 ☆   |
|006 (F#-1)|↓                   |
|007 (G-1) |↓                   |
|008 (G#-1)|Noise Guitar G#1 ☆  |
|009 (A-1) |↓                   |
|010 (A#-1)|↓                   |
|011 (B-1) |↓                   |
|012 (C0)  |Noise Guitar C2 ☆   |
|013 (C#0) |↓                   |
|014 (D0)  |↓ ☆                |
|015 (D#0) |↓                   |
|016 (E0)  |↓                   |
|017 (F0)  |Noise Guitar F2 ☆   |
|018 (F#0) |↓                   |
|019 (G0)  |↓                   |
|020 (G#0) |Noise Guitar G#2 ☆  |
|021 (A0)  |↓                   |
|022 (A#0) |↓                   |
|023 (B0)  |↓                   |
|024 (C1)  |Noise Guitar C3 ☆★ |
|025 (C#1) |↓                   |
|026 (D1)  |↓ ☆                |
|027 (D#1) |↓                   |
|028 (E1)  |↓                   |
|029 (F1)  |Noise Guitar F3 ☆★ |
|030 (F#1) |↓                   |
|031 (G1)  |↓                   |
|032 (G#1) |Noise Guitar G#3 ☆★|
|033 (A1)  |↓                   |
|034 (A#1) |Bass Drum3           |
|035 (B1)  |Bass Drum2           |
|036 (C2)  |Bass Drum1           |
|037 (C#2) |Snare Drum3          |
|038 (D2)  |Snare Drum1          |
|039 (D#2) |Snare Drum4          |
|040 (E2)  |Snare Drum2          |
|041 (F2)  |Low Tom2             |
|042 (F#2) |Closed Hi-Hat        |
|043 (G2)  |Low Tom1             |
|044 (G#2) |Pedal Hi-Hat         |
|045 (A2)  |Mid Tom2             |
|046 (A#2) |Open Hi-Hat          |
|047 (B2)  |Mid Tom1             |
|048 (C3)  |High Tom3            |
|049 (C#3) |Crash Cymbal1        |
|050 (D3)  |High Tom2            |
|051 (D#3) |Ride Cymbal1         |
|052 (E3)  |High Tom1            |
|053 (F3)  |Ride Bell            |
|054 (F#3) |Tambourine           |
|055 (G3)  |Reverse Cymbal       |
|056 (G#3) |Cowbell              |
|057 (A3)  |Crash Cymbal2        |
|058 (A#3) |Vibra-slap           |
|059 (B3)  |Ride Cymbal2         |
|060 (C4)  |Noise Guitar C3 ☆★ |
|061 (C#4) |↓                   |
|062 (D4)  |↓ ☆                |
|063 (D#4) |↓                   |
|064 (E4)  |↓                   |
|065 (F4)  |Noise Guitar F3 ☆★ |
|066 (F#4) |↓                   |
|067 (G4)  |↓                   |
|068 (G#4) |Noise Guitar G#3 ☆★|
|069 (A4)  |↓                   |
|070 (A#4) |↓                   |
|071 (B4)  |↓                   |
|072 (C5)  |Noise Guitar C4 ☆   |
|073 (C#5) |↓                   |
|074 (D5)  |↓ ☆                |
|075 (D#5) |↓                   |
|076 (E5)  |↓                   |
|077 (F5)  |Noise Guitar F4 ☆   |
|078 (F#5) |↓                   |
|079 (G5)  |↓                   |
|080 (G#5) |Noise Guitar G#4 ☆  |
|081 (A5)  |↓                   |
|082 (A#5) |↓                   |
|083 (B5)  |↓                   |
|084 (C6)  |Noise Guitar C5 ☆   |
|085 (C#6) |↓                   |
|086 (D6)  |↓ ☆                |
|087 (D#6) |↓                   |
|088 (E6)  |↓                   |
|089 (F6)  |Noise Guitar F5 ☆   |
|090 (F#6) |↓                   |
|091 (G6)  |↓                   |
|092 (G#6) |Noise Guitar G#5 ☆  |
|093 (A6)  |↓                   |
|094 (A#6) |↓                   |
|095 (B6)  |↓                   |
|096 (C7)  |Noise Guitar C6 ☆   |
|097 (C#7) |↓                   |
|098 (D7)  |↓                   |
|099 (D#7) |↓                   |
|100 (E7)  |↓                   |
|101 (F7)  |Noise Guitar F6 ☆   |
|102 (F#7) |↓                   |
|103 (G7)  |↓                   |
|104 (G#7) |↓                   |
|105 (A7)  |↓                   |
|106 (A#7) |↓                   |
|107 (B7)  |↓                   |
|108 (C8)  |Noise Guitar C7 ☆   |
|109 (C#8) |↓                   |
|110 (D8)  |↓                   |
|111 (D#8) |↓                   |
|112 (E8)  |↓                   |
|113 (F8)  |↓                   |
|114 (F#8) |↓                   |
|115 (G8)  |↓                   |
|116 (G#8) |↓                   |
|117 (A8)  |↓                   |
|118 (A#8) |↓                   |
|119 (B8)  |↓                   |
|120 (C9)  |Noise Guitar C8 ☆   |
|121 (C#9) |↓                   |
|122 (D9)  |↓                   |
|123 (D#9) |↓                   |
|124 (E9)  |↓                   |
|125 (F9)  |↓                   |
|126 (F#9) |↓                   |
|127 (G9)  |↓                   |

----------------------------------------------------------------------

§2 MIDIデータ作成ガイド
------------------------

DMG-CPU1.5.SF2をゲームボーイ音源らしく鳴らすためのMIDIデータ作成ガイドです。

### 発音数などの制約 #################################################

* ゲームボーイ音源はCH1, CH2（矩形波）、CH3（波形メモリ）、
  CH4（ノイズ）の4音なので、その発音数を厳守してトラックを作成します。
* 音色を変えるなど、トラックを分ける場合はリリースの残りに気をつけて、
  必要であればベロシティ1のゴーストノートで発音を止めます。
* ゲームボーイ音源はスイープが1つしかありませんので、
  CH1, CH2（矩形波）のサブ音色（キック等）を重ねて鳴らすことは非推奨です。

#### 単音発音について

* 全音色にExclusive Classを設定しているため、強制的に単音で発音されます。
* サウンドフォントに対応したハード・ソフトやプラグインにモノフォニックの設定があれば、
  オンにしたほうがよりよい効果が得られます。
* MIDIデータ（SMF）を作成する場合も、ソングヘッダーにコントロールチェンジ
  126番（モノオン）を設定したほうがよいでしょう。
* なお、1トラックで和音を鳴らすことができないので人によっては不便でしょうが、
  作者としてはExclusive Classを外して使われるのは不本意です。

### トラック音量（ボリューム、エクスプレッション） ###################

* ボリューム、エクスプレッションは128（最大値）に固定します。

### ノート音量（ベロシティ） #########################################

* ベロシティは8の倍数の16段階とします。
  ただし、波形メモリは128・72・40の3段階しか使えません。
* メロディーは96、バッキングは72、波形メモリとノイズは128を基準値として
  適宜調整します。
* オーケストラヒットはディレイをかけてサンプリングしているため、
  ベロシティは128固定とします。
* ベロシティがパーセント表示の場合は次の4段階で割り切って打ち込んでもよいでしょう。
  * 100%（波形メモリ、ノイズ）
  * 75%（メロディー）
  * 50%（バッキング）
  * 25%（ディレイ）

|ベロシティ|パーセント|
|----------|----------|
|128       |100%      |
|120       |93.75%    |
|112       |87.50%    |
|104       |81.25%    |
|96        |75%       |
|88        |68.75%    |
|80        |62.50%    |
|72        |56.25%    |
|64        |50%       |
|56        |43.75%    |
|48        |37.50%    |
|40        |31.25%    |
|32        |25%       |
|24        |18.75%    |
|16        |12.50%    |
|8         |6.25%     |

### パン #############################################################

* ゲームボーイ音源のパンは泣き別れステレオなので、
  1（真左）・64（中央）・128（真右）以外使えません。
* スムーズなパンニングを行うには左右のノート音量差（ベロシティ値）を
  利用します（下表参照）。
* スムーズなパンニングでは左右同時に同じノートを鳴らすことになるので、
  発音数を抑えたい場合はノートの長さを半分にして櫛抜きにします。  
  例えば表拍を左に、裏拍を右にパンを振って、1音でアルペジオやグリッサンドを鳴らすのです。

#### 左から右へパンニングさせる場合のベロシティ値

|ベロシティ左|ベロシティ右|
|------------|------------|
|128         |1           |
|120         |8           |
|112         |16          |
|104         |24          |
|96          |32          |
|88          |40          |
|80          |48          |
|72          |56          |
|64          |64          |
|56          |72          |
|48          |80          |
|40          |88          |
|32          |96          |
|24          |104         |
|16          |112         |
|8           |120         |
|1           |128         |

----------------------------------------------------------------------

§3 沿革
--------

2003年のコミックマーケット65で『ちがうの！ライクじゃないんだよーっ』という、
ゲーム音楽やオリジナル曲をゲームボーイ音源でアレンジしたCDを頒布しました。  
このCDのために作ったのが一番最初のゲームボーイサウンドフォントでした。

当時勤めていた会社に役目を終えて放置されていたゲームボーイ開発機がありました。  
商業デビュー作となった『ラブひなポケット』など、
数本のゲームボーイカラー用ソフトの音楽をデバッグした思い出の開発機です。

デビュー当時は仮音色で作曲したMIDIデータをMMLに半手動でコンバートし、
5インチフロッピーディスクに保存して開発機でロードするという手順で
デバッグしていました。  
ゲームボーイの出音を確かめながら作曲するということができなかったのです。

もうゲームボーイで仕事をすることはなくなってしまったけれど、
今なら当時の不満が解消できると思ってサウンドフォントを作ったのでした。  
ゲームボーイの開発経験を踏まえ、理想の音楽表現を追求するために作ったのが  
ゲームボーイサウンドフォント「DMG-CPU1.5.SF2」です。

### Gameboy.SF2 (Ver.2003-11-20) #####################################

非公開バージョンです。

ゲームボーイ開発機からデフォルト設定音色のみをサンプリングした、
必要最低限のサウンドフォントです。

#### 特徴

* 矩形波はデューティ比1:3、ハードウェアエンベロープは下降の7段階目
  （最も長い減衰）のみ。ビブラートの強弱で2種類のバリエーション。
* 波形メモリは1音色のみ。
* ノイズはバスドラム、スネアドラム、クローズハイハットのみ。

#### 使用作品

EDIA LABEL
: * 2003/12/30 ちがうの！ライクじゃないんだよーっ

### PocketCamera.SF2 (Ver.2004-04-29) ################################

非公開バージョンです。

Gameboy.SF2にポケットカメラで作った音を追加したもの。  
ただこの時点ではポケットカメラで波形メモリがいじれることを知りませんでした。

#### 特徴

* 矩形波にデューティ比1:1と1:7の音色を追加。
* 波形メモリに矩形波1:1とポケットカメラのデフォルト音色を追加。
* ノイズにオープンハイハット・クラッシュシンバルと、
  バスドラム・スネアドラムのバリエーションを追加。  
  （この時点でタムはサンプリングしていたが実装は見送った）
* 短周期ノイズのギターを追加。
  （当初は実機で鳴る音程のみだったが、後に音程を付けた）

#### 使用作品

EDIA LABEL
: * 2004/05/02 超音速のGB少女
  * 2004/10/09 GBreeze
  * 2004/12/29 暮れGo!Go!録
  * 2005/05/01 ふぉ～ぽりふぉにっくまじっく ゲームボーイ音源アレンジ集
  * 2005/08/14 蕾電伝説《つぼみでんでんせつ》
  * 2006/08/13 ふぉ～ぽりふぉにっくまじっく2 ゲームボーイ音源アレンジ集2
  * 2006/12/31 えでぃあ すぺしゃる みゅ～じっく 萬両箱 ～活動満了記念～
  * 2006/12/31 エディア・レーベル・ゲーム・ミュージック・メモリアル・ベスト

ASIA LUNAR
: * 2007/04/29 ふぉ～ぽりふぉにっくまじっく3 ゲームボーイ音源アレンジ集3

サークルFMPSG
: * 2005/05/01 [FMPSG003 -The Chiptune Memories-](https://fmpsg.info/discography/FPCR-003/)
  * 2006/04/29 [FMPSG005 -elemental master-](https://fmpsg.info/discography/FPCR-005/)
  * 2007/10/08 [FMPSG008 -Flower in the darkness-](https://fmpsg.info/discography/FPCR-008/)

Circle S&G
: * 2007/8/17 [超懐古主義！](https://sandg.sakura.ne.jp/CD2007.htm)

### DMG-CPU.SF2 (Ver.2007-12-18) #####################################

一般公開バージョンです。  
2017年02月23日をもって配布・サポートを終了しました。

ポケットカメラで波形メモリ音色を追加しました。

ゲームボーイサウンドフォントはSound Blaster Live!で制作しましたが、
一般公開によって多様な環境で利用されるようになり、
作者の意図通りに動作しないケースも見られるようになりました。

#### 特徴

* 波形メモリに矩形波1:3と1:7、GXSCCから移植した25音色を追加。
* ノイズにPocketCamera.SF2で実装を見送っていたタムと、
  バスドラム・スネアドラムのバリエーションを追加。

* [GXSCC](https://gashisoft.web.fc2.com/)

#### 既知の問題点

Q. 波形メモリ音色に三角波が2つあるが、どちらも同じに聞こえる。
: A. プログラムチェンジ14番「Triangle1（三角波1）」の波形に対して、
  プログラムチェンジ15番「Triangle2（三角波2）」の波形は倍周期となっており、
  本来は1オクターブ上の音が鳴るはずなのですが、両方とも同じ音程に
  設定してしまっています。その結果、三角波2の音はくすんでしまっています。  
  既にこの音色を使ってMIDIデータを作成されている方もいらっしゃるので、
  仕様として残します。  
  気になる人は、Vienaなどのサウンドフォントエディタを使って修正してみてください。  
  ※DMG-CPU1.5.SF2では修正済みです。

#### 使用作品

ASIA LUNAR
: * 2007/12/31 ふぉ～ぽりふぉにっくまじっく4 ゲームボーイ音源アレンジ集4
  * 2008/03/09 加賀峰《かがみね》
  * 2008/04/06 Four Polyphonic Magic -International Sampler-
  * 2008/04/26 Four Polyphonic Magic -Original Sampler-
  * 2008/07/24 INTO THE ROSE CASTLE
  * 2008/08/16 ふぉ～ぽりふぉにっくまじっく5 ゲームボーイ音源アレンジ集5
  * 2008/10/13 ふぉ～ぽりふぉにっくまじっくLEVEL1
  * 2009/05/05 怒加賀峰大出撃《どかがみねだいしゅつげき》
  * 2009/08/15 1925th
  * 2009/12/30 ふぉ～ぽりふぉにっくまじっく6 シューティングスペシャル
  * 2009/12/30 播嶺《まくね》
  * 2010/01/26 Bloody Tribute ～ドラキュラ伝説Ⅱ風仮想サントラ～
  * 2010/05/05 REMEMBER THE EVIL BACTERIANS?
  * 2010/05/05 rainbow seasons -ナナ色の季節-
  * 2010/08/14 ふぉ～ぽりふぉにっくまじっく7
  * 2010/10/31 JUNK BOX Ⅰ＆Ⅱ ～復活の音源～
  * 2012/03/02［ACIDized WAV］ゲームボーイループ素材集アルペジオ編
  * 2015/03/01 footprints 萌尽狼オリジナル曲ベスト
  * 2016/11/06 旧校舎爆撃隊 ～空中戦車道2 颱風高校編～
  * 2017/11/12 アジア・ルナー グレイテスト・ヒッツ

サークルFMPSG
: * 2008/03/09 [FMPSG009 -Remember the chiptune-](https://fmpsg.info/discography/FPCR-009/)
  * 2008/10/13 [FMPSG010 -bridge-](https://fmpsg.info/discography/FPCR-010/)
  * 2009/05/05 [FMPSG011 -kaleidoscope-](https://fmpsg.info/discography/FPCR-011/)
  * 2009/10/11 [FMPSG012 -Burning Stone-](https://fmpsg.info/discography/FPCR-012/)
  * 2010/10/31 [FMPSG014 -Mystic aurora-](https://fmpsg.info/discography/FPCR-014/)

### GBMC_Drums.SF2 (Ver.2009-12-20) ##################################

一般公開バージョンです。  
2017年02月23日をもって配布・サポートを終了しました。

DMG-CPU.SF2用のドラム音色拡張サウンドフォントです。

#### 特徴

* 矩形波およびノイズで鳴らしたPCMドラム（バスドラム・スネアドラム・タム）を収録。
* ノイズのハイハット・クラッシュシンバルがよりリアルに。
* あらかじめ左右にパンを振ることで打ち込みの手間を軽減。

#### 使用作品

ASIA LUNAR
: * 2009/12/30 播嶺《まくね》

### DMG-CPU2.SF2 (Ver.2012-01-26) ####################################

クローズドベータバージョンです。

#### 特徴

* 矩形波のハードウェアエンベロープ（下降・上昇、各7段階）を全て収録。※未実装
* 矩形波に高速アルペジオ、オーケストラヒット音色を追加。
* 波形メモリにVRC6相当の矩形波（8種類）とノコギリ波、ファミコン相当の三角波を追加。
* ドラムと短周期ノイズのギターを統合し、シンバル、パーカッション音色を追加。

#### 既知の問題点

Q. 矩形波にビブラートがかかっていない。
: A. ビブラートの有無で音色を別々に作成すると
  サウンドフォントが煩雑化・肥大化する問題があり作業が中断しました。

Q. 波形メモリのGXSCC音色が未実装。
: A. 当初は全波形をGBMCで作り直す予定で、作業が後回しになっていました。

#### 使用作品

ASIA LUNAR
: * 2013/10/27 ふぉ～ぽりふぉにっくまじっく8

### DMG-CPU1.5.SF2 (Ver.2012-03-17) ##################################

一般公開バージョンです。  
4年ぶりのバージョンアップです。DMG-CPU.SF2との互換性はありません。

MMLコンパイラGBMC (GameBoy Music Compiler)で音色を追加し、
ゲームボーイエミュレータBGBで演奏してサンプリングしました。

* [GBMC](http://mydocuments.g2.xrea.com/html/gb/sounddriver.html)
* [BGB](https://bgb.bircd.org/)

なお「DMG-CPU1.5.SF2」は「DMG-CPU2.SF2」開発中に諸事情で開発継続が
困難になり「DMG-CPU.SF2」との折衷案で完成させたものです。

#### 特徴

* 矩形波に高速アルペジオ、オーケストラヒット音色を追加しました。  
  細かい音符を打ち込む手間から解放されます。
* 矩形波の音域外にバスドラム、シンセタムを追加。ハウス系の曲作りが容易に。
* 波形メモリにVRC6相当の矩形波（8種類）とノコギリ波、ファミコン相当の三角波を追加。
* ドラムと短周期ノイズのギターを統合し、シンバル、パーカッション音色を追加。  
  GM音源のドラムキットをある程度カバーしています。
* ゲームボーイ実機よりも広い音域で発音されるようになっています。  
  短周期ノイズのギターもきれいな音階で演奏できます。

#### ヒント

* パワーコードの高速アルペジオは、中低音域でディストーションギターとして
  使うより、高音域でブラスセクションとして使うことが多いです。

#### 既知の問題点

Q. 音色が少ない
: A. 矩形波の減衰音はハードウェアエンベロープでいうところの下降の7段階目
  （最も長い減衰）のみで物足りなさを感じるかもしれません。

Q. 音量が小さい
: A. 原音に忠実なサンプリングと音割れ防止のため音量が小さめであり、
  最終的にマスターボリュームを上げたりマキシマイザーをかける必要があります。

Q. Studio Oneのソフト音源「Presence」で
Square Perc.最低音（ノートNo.000 (C-1)「Square Bass Drum1」）が鳴りません。
: A. Studio Oneを有料版にアップグレードして他のVSTiを使うなどの方法が
  考えられますが、「Presence」での解決方法はありません。

Q. 「TiMidity++」で矩形波ドラム音色のリリースが残ってしまい、
1チャンネルで2音以上発音されてしまう。
: A. ソングヘッダーにコントロールチェンジ126番（モノオン）を追加することで
  問題を回避できます。

Q. 「TiMidity++」でノイズドラム音色のリリースが残ってしまい、
1チャンネルで2音以上発音されてしまう。
: A. チャンネル10はドラムセットのボイスリザーブのため、
  他のチャンネルとは違い前述のようにコントロールチェンジ126番（モノオン）を
  追加しただけでは問題を回避できないようです。  
  チャンネル10は使用せずに他のチャンネル（チャンネル1～9・11～16）で
  ノイズドラム音色を使用し、ソングヘッダーにコントロールチェンジ126番
  （モノオン）を追加することで問題を回避できます。

Q. 「TiMidity++」でノイズギターのノートオフが受信されず、
ゲートタイムで発音が制御できない。
: A. 発音を切りたいタイミングにベロシティ1のゴーストノートを入力することで
  問題を回避できます。

#### 使用作品

ASIA LUNAR
: * 2013/10/27 ふぉ～ぽりふぉにっくまじっく8
  * 2014/11/28 190F《イチキュウゼロエフ》
  * 2017/09/10 禁重音狂奏曲
  * 2017/11/12 アジア・ルナー グレイテスト・ヒッツ

kaguyadepth
: * 2018/07/08 Chikkutune 竹製楽器×チップチューン
  * 2019/04/28 ツァイトライゼパンツァー
  * 2020/01/04 逆ディウス
  * 2020/12/20 逆ディウスⅡ～望野のアフーゴ～
  * 2021/07/04 ウンディーネ（仮想ゲームサントラ）
  * 2022/06/05 ウンディーネ2 時空を超えて
  * 2022/06/05 ウンディーネ サルベージ＋殺人山革命
  * 2022/12/03 ウンディーネ3 幼い王子と予言の続き
  * 2023/03/25 KAGUYADEPTH VS ASIA LUNAR VS EDIA LABEL
  * 2023/05/28 エグゼリカ総集編
  * 2023/06/17 ゲームトレジャー4 大夜界村 スペシャルディスク
  * 2024/03/23 ふぉ～ぽりふぉにっくまじっくLEVEL2
  * 2024/06/23 GBQ
  * 2024/10/27 be plus 美プラ＋チップチューン

EtlanZ
: * 2012/04/30 [熱血大音楽祭 ～FRIENDSHIP FOR GAMEMUSIC～](http://www.etlanz.com/excd5/)

サークルFMPSG
: * 2012/04/30 [FMPSG017 -ダンシングクイーン-](https://fmpsg.info/discography/FPCR-017/)
  * 2012/10/28 [FMPSG018 -Metamorphose-](https://fmpsg.info/discography/FPCR-018/)
  * 2013/04/29 [FMPSG019 -JUKE BOX-](https://fmpsg.info/discography/FPCR-019/)
  * 2013/10/27 [FMPSG020 -DECADE-](https://fmpsg.info/discography/FPCR-020/)
  * 2015/10/25 [FMPSG Originals](https://fmpsg.info/discography/FPCR-101/)
  * 2016/04/24 [FMPSG022 -Titan-](https://fmpsg.info/discography/FPCR-022/)
  * 2017/04/30 [FMPSG023 -marble-](https://fmpsg.info/discography/FPCR-023/)
  * 2020/03/01 [FMPSG024 -period.-](https://fmpsg.info/discography/FPCD-024/)

----------------------------------------------------------------------

§4 ライセンスについて
----------------------

過去に一般公開した「DMG-CPU.SF2」「GBMC_Drums.SF2」「DMG-CPU1.5.SF2」には、
明確なライセンスがなく、個人利用の範囲なら自由に使ってよいというものでした。

フリー素材として紹介され、ニコニコ動画やSoundCloudなどで利用されてきました。  
使用にあたって作者への連絡は不要でしたが、ご相談いただければ快諾したこともありました。  
§3に作者の同人作品をまとめましたが、他にも使用例があるのではないかと思います。  
使ったことを明記してくださった作品が多く、検索して視聴したこともありました。

ところが近年、「DMG-CPU1.5.SF2」で作った曲をインディーゲームに組み込みたいなど、
ライセンスに関する問い合わせが多くなり、権利的にクリアな他の選択肢（§5参照）も
多くなってきたことから、使用をお断りするケースも増えてきました。

サウンドフォントの性質上、音色の一部を他のサウンドフォントに組み込むことも
技術的には可能ですが（§6参照）そうしたお問い合わせにもお断りせざるを得ない状況です。

* 「DMG-CPU1.5.SF2」は、個人利用の範囲なら自由に使ってよい。
* 「DMG-CPU1.5.SF2」を使うにあたって作者への連絡は不要。
* 現状、お問い合わせいただいた場合には、お断りするケースが多い。

上記3点の意味が理解できない場合は、使用を控えたほうが無難かと思われます。  
よろしくお願いいたします。

----------------------------------------------------------------------

§5 DMG-CPU1.5.SF2以外の選択肢
------------------------------

### ゲームボーイソフト ###############################################

任天堂
: * [ポケットカメラ](https://www.nintendo.co.jp/n02/dmg/hardware/pocket_c/)

Johan Kotlinski
: * [Little Sound Dj (LSDj)](https://littlesounddj.com/)（トラッカー）

Oliver Wittchow
: * [nanoloop](https://www.nanoloop.com/one/)

JESTER / Rage
: * pocket music

### トラッカー #######################################################

Chris Maltby
: * [GB Studio 3](https://www.gbstudio.dev/)（ゲームビルダー）

Brennan Ringey
: * [Trackerboy](https://www.trackerboy.org/)

* [Game Boy Tracker](https://www.vgmpf.com/Wiki/index.php/Game_Boy_Tracker)
* [hUGETracker](https://nickfa.ro/wiki/HUGETracker)
* [DefleMask](https://www.deflemask.com/)

### ハードウェア #####################################################

Trash80
: * [Arduinoboy](https://github.com/trash80/Arduinoboy)

Dirtywave
: * [M8 Tracker](https://dirtywave.com/)（トラッカー）

### シーケンサー #####################################################

AMURu
: * [PIRORO](https://amuru9.wixsite.com/my-site)

LMMS開発チーム
: * [LMMS (Linux Multi Media Studio)](https://lmms.io/)

### プラグイン #######################################################

SocaLabs
: * [PAPU](https://socalabs.com/synths/papu/)

t-sin
: * [SoyBoy SP](https://bak-shaver.booth.pm/items/3871410)

shadowsora
: * [Soraboy](https://shadowsora211.itch.io/soraboy)

NN Audio
: * [Game Boi](https://nnaud.io/product/game-boi-retro-sounds-free-plugin/)

Reflekt Audio
: * [GameX](https://www.kvraudio.com/product/gamex-by-reflekt-audio)

Loot Audio
: * [Fameboy](https://www.pluginboutique.com/product/1-Instruments/55-Kontakt-Instrument/6039-Fameboy)

Bedroom Producers Blog / SampleScience
: * [GB DrumBox](https://bedroomproducersblog.com/2019/11/14/gb-drumbox/)

Plogue
: * [chipsounds](https://www.plogue.com/products/chipsounds.html)

Impakt Sound Works
: * [Super Audio Cart](https://impactsoundworks.com/product/super-audio-cart/)
  * [Supre Audio Boy](https://impactsoundworks.com/product/super-audio-boy/)

UVI
: * [Toy Suite](https://www.uvi.net/jp/unconventional/toy-suite.html)
  * [8-Bit Synth](https://www.uvi.net/jp/unconventional/8bit-synth.html)

Tom Yaxley
: * [RetroPlug](https://github.com/tommitytom/RetroPlug)

### サウンドフォント #################################################

ひやめし
: * [Hiyameshi-DMG](https://booth.pm/ja/items/4710188)

### サンプルパック ###################################################

Akihiko Matsumoto
: * [Game Boy (Sample Pack)](https://akihikomatsumoto.bandcamp.com/album/game-boy-sample-pack)

Daniel Davis
: * [an0va sample pack](https://an0va.bandcamp.com/album/an0va-sample-pack)

Blezz Beats
: * [Game Man](https://www.blezzbeats.com/)

Gradient Lab
: * [Gameboy LSDJ Re​-​sampled Drums, Percussion & FX Sample Pack](https://gradientlab.bandcamp.com/album/gradient-lab-gameboy-lsdj-re-sampled-drums-percussion-fx-sample-pack-free-download)

Bedroom Production Blog
: * [Game Boy LSDJ Noise And Glitch Sessions](https://bedroomproducersblog.com/2011/02/08/free-sample-pack-5-game-boy-lsdj-noise-and-glitch-sessions/)

Analog Tecne Model
: * [41 GameBoy layered samples](https://www.atm23.net/kits.php)

CremaSound
: * [That Game Boy Bass](https://cremasound.shop/products/that-game-boy-bass)

Midi Error
: * [Deluxe ChipShop](https://rhythm-lab.com/chipshop-deluxe/)

Rhythm Lab
: * [Gameboy sound fx](https://rhythm-lab.com/gameboy-samples/)

scythe
: * [LSDj_drum.zip](https://x.com/scythe1005/status/1237723097970520066)

Introspectral
: * [Glitchboy Sample Pack](https://soundpacks.com/free-sound-packs/glitchboy-sample-pack/)

Cremacaffè Design
: * [LSDJ samples pack](https://cremacaffeshop.bandcamp.com/album/lsdj-samples-pack)

Nuclear Mushroom Boom
: * [O​-​VOID Chiptune Sega Gameboy Sample Pack](https://nmboom.bandcamp.com/album/o-void-chiptune-sega-gameboy-sample-pack)

### MMLコンパイラ ####################################################

Bookworm
: * [GameBoy Music Compiler (GBMC)](http://mydocuments.g2.xrea.com/html/gb/sounddriver.html)

### オンラインコンバータ #############################################

野池賢二
: * [SMF to MP3 with ぼーか郎](https://noike.info/~kenzi/cgi-bin/smf2mp3/)

### 参考資料 #########################################################

scythe
: * [GAMEBOY Waveform Archives](https://scythe1005.wixsite.com/gb-waveforms)

ニコニコ大百科
: * [GB音源とは (ゲームボーイオンゲンとは)](https://dic.nicovideo.jp/id/186393)

* [GBDev (Game Boy Development community)](https://gbdev.io/)

ゲームボーイで音楽やろうと思ったとき、これだけ多くの選択肢がある中で、
拙作ゲームボーイサウンドフォント「DMG-CPU1.5.SF2」に興味を持ってくださって
本当にどうもありがとうございます。

「DMG-CPU1.5.SF2」は完成から既に10年以上経過しています。設計が古いところも
あるし、あなたの要望に十分お応えすることができないかもしれません。  
ただし、作者自身が使い続けている限り、サポートは最低限継続していくつもりです。  
末長くご愛用いただけましたら幸いです。

#### ヒント

「PAPU」には波形メモリ音源がないので次のようなプラグインで補うとよいでしょう。
: * Masaki Mori - [SANA 8BIT VST](https://github.com/m-masaki72/SANA_8BIT_VST)
  * Sam - [Chip32](https://www.kvraudio.com/product/chip32_by_sam)（32bit版のみ）

「DMG-CPU1.5.SF2」に他のプラグインやサンプルパックをミックスする場合は、
素の矩形波で音量を合わせるとよいでしょう。
: * 「DMG-CPU1.5.SF2」が0dBのとき、「Soraboy」は-16dBで音量が揃う。
  * 「DMG-CPU1.5.SF2」が0dBのとき、『Weekend Hero』特設サイトで
    無料配布していた「MARU303特製チップチューン音源素材」は-21dBで音量が揃う。

----------------------------------------------------------------------

§6 基礎知識
------------

### ゲームボーイについて #############################################

1989年4月21日に任天堂が発売した携帯型ゲーム機です。故・横井軍平氏が開発し、
彼の哲学である「枯れた技術の水平思考」も有名になりました。

ファミコンと同じコントローラーに4階調のモノクロ液晶画面を備え、
サウンドは内蔵モノラルスピーカーとステレオヘッドホン出力に対応。
また、2～4台のゲームボーイと通信対戦するための端子も用意されていました。

カートリッジを交換してさまざまなゲームが遊べる携帯ゲーム機としては
世界初のヒット商品となり、『テトリス』や『ポケットモンスター』など
ゲームボーイからヒットしたゲームソフトは数知れません。

モノクロ画面であることを除けばファミコンに近い性能の8ビットゲーム機ですが、
細かな点でグラフィックやサウンドは機能強化されており、モノクロ画面でありながら
迫力のあるゲーム演出が可能なハードウェアでした。

特にサウンドはステレオ出力に対応していること、ファミコンの三角波のかわりに
波形メモリ音源を搭載することで音色表現の幅が広がったことなどが特徴として
挙げられ、現在では楽器として愛好する人も世界中にいます。

### サウンドフォントについて #########################################

1994年3月にクリエイティブテクノロジーが発売したパソコン用のサウンドカード
「Sound Blaster AWE32」に初めて搭載された、PCMシンセサイザーの音色を
フォントファイルのように自由に選べるようにできる機能のことです。

これはサンプラーという楽器そのものであり、サウンドカード付属のものや
市販のサウンドフォントだけでなく、ユーザーが自由にサウンドフォントを作成・
編集することも可能なものです。

1998年には現在普及しているSF2フォーマットが登場し、サウンドフォントに
対応したソフト・ハードの選択肢が広がりました。現在ではクリエイティブ
テクノロジーの製品がなくてもサウンドフォントを使うことができます。

ちなみにサウンドフォントは、実用的なサンプラーとしては世界初のヒット商品
となった「Emulator I」を1982年に発売したE-MUが、1993年3月にクリエイティブ
テクノロジーに買収されて実現したものです。

### サンプラーについて ###############################################

楽器の演奏や人の声などを録音して素材化したものを、鍵盤やボタン・パッド
などに割り当てて、音階を変えたり繰り返したりして再生するPCMシンセサイザー
の一種です。

一般的なシンセサイザーは電圧制御によって発振する矩形波やサイン波といった
単純波形を組み合わせたり、フィルターを通すことによって音色を変化させて
さまざまな楽器に似た音を作り出していますが、リアルさには限界もあります。

ゲーム音楽の世界では1985年頃からセガの『アウトラン』や『スペースハリアー』
といった大型体感ゲームなどでドラムや人の声などFM音源が苦手とする部分に
サンプリングされた音色が使われるようになり、スーパーファミコン以降は
ゲーム機の中にサンプラー（一般的にはPCM音源と呼ばれます）が搭載されるように
なりました。

サンプラーは楽器メーカー各社の独自フォーマットの他に、多少互換性に難は
あるものの幅広いソフト・ハードで利用できる互換フォーマットがあり、
サウンドフォントはそのうちのひとつです。

### DAWソフトについて ################################################

デジタル・オーディオ・ワークステーションを略してDAWです。
DAWの読み方は「でぃーえーだぶりゅー」または「だう」。
私は「でぃーえーだぶりゅー」派です。

オーディオも扱えるようにしたシーケンスソフトのことで、録音、編集、
ミキシングなど一連の作業がひとつのソフト内で完結できることから、
現在のDTM（デスクトップ・ミュージック）の主流となっています。

そもそもワークステーションとは、一般にキーボードと呼ばれる電子楽器の中でも、
特にシンセサイザー（音作り担当）とシーケンサー（演奏担当）が一体型に
なったもののことをいいます。ヤマハのMOTIFやコルグのTRITON
（『けいおん！』の琴吹紬が使用）などが代表的です。

シンセサイザーだけのキーボードだとレコーダーがないと曲作りができませんが、
ワークステーションだと弾きながら曲作りができます。
これをパソコンで実現したものがDAWソフトといえるでしょう。
プロ用の音楽制作ソフトのイメージがありましたが、VOCALOID初音ミクのヒットで
DAWソフトも一気に普及しました。

パソコン用のシーケンスソフトは、もともとMIDIデータを編集するためのものでしたが、
これにオーディオ機能を追加したものがDAWになったという経緯があります。
現在もフリーソフトのDominoなど、MIDIデータに特化したシーケンサーもありますが、
パッと見では区別がつかないので注意が必要です。

----------------------------------------------------------------------

§7 お問い合わせ先
------------------

webmaster@kaguyadepth.jp

作者：萌尽狼《もえつきろ》

※メールの返信は遅れる場合がありますので、何卒ご容赦いただけますと幸いです。

「DMG-CPU1.5.SF2」readme.md Ver.2025/10/19
(C) 2003-2006 EDIA LABEL
(C) 2007-2017 ASIA LUNAR
(C) 2018-2025 kaguyadepth
